#pragma once

#define FONT_EXTRAROWS 1
#define FONT_IMAGEROWS 1


#define CHAR_STAR L"\x090"
#define CHAR_GREYSTAR L"\x091"
#define CHAR_PLAY L"\x092"
#define CHAR_RANDOM L"\x093"
#define CHAR_CLOSE L"\x094"
#define CHAR_CD L"\x095"

#define CHAR_ELIPSIS L"\x07F"
#define CHAR_DEGREES L"\x080"
#define CHAR_LBRKT L"\x081"
#define CHAR_RBRKT L"\x082"

inline void GetXMLSpecialChars(vector<wstring>& SpecialCharacters)
{
	SpecialCharacters.push_back(wstring(CHAR_ELIPSIS)+L"elip;");
	SpecialCharacters.push_back(wstring(CHAR_DEGREES)+L"deg;");

	SpecialCharacters.push_back(wstring(CHAR_STAR)+L"star;");
	SpecialCharacters.push_back(wstring(CHAR_GREYSTAR)+L"gstar;");
	SpecialCharacters.push_back(wstring(CHAR_PLAY)+L"play;");
	SpecialCharacters.push_back(wstring(CHAR_RANDOM)+L"random;");
	SpecialCharacters.push_back(wstring(CHAR_CD)+L"cd;");
	SpecialCharacters.push_back(wstring(CHAR_LBRKT)+L"lb;");
	SpecialCharacters.push_back(wstring(CHAR_RBRKT)+L"rb;");
}

inline void GetExtraGlyphs(vector<wstring>& extraglyphs)
{
	extraglyphs.push_back(L"star.png");
	extraglyphs.push_back(L"greystar.png");
	extraglyphs.push_back(L"rightblue.png");
	extraglyphs.push_back(L"random.png");
	extraglyphs.push_back(L"close.png");
	extraglyphs.push_back(L"cd.png");
}

inline char GetExtraChar(int i)
{
	char res = ' ';
	switch (i)
	{
	case 0x80:
		res = '';
		break;
	case 0x81:
		res = '[';
		break;
	case 0x82:
		res = ']';
		break;
	}
	return res;
}
